function locus = symlocc(b,a,r1,r2,dsmax,scale)
% SYMLOCC Plots symmetric root locus for continuous system
%
%	locus = symlocc(b,a,r1,r2,dsmax,scale)
%	locus = symlocc(b,a,r1,r2,dsmax)
%
%	Plots the stable part of the root locus corresponding to
%	a(s)*a(-s) + r*b(s)*b(-s) for r1 < r < r2. Also the roots of
%       a (r = Inf) and the roots of b (r = 0) are plotted.
%
%       The increments in r are calculated such that abs(ds) < dsmax.
%       The r-values and the roots are stored in locus, with the r-values
%       in the first column.
%
%	scale (optional) takes the form [xmax xmin ymin ymax]. If scale is 
%	omitted an attempt is done to find a plot scale that gives an aspect
%	ratio as close to 1 as possible.
%
%       Use PZGRID to plot grid and real/imaginary axis.

% Kjell Gustafsson, original file due to Ulf Holmberg
% LastEditDate : Thu May 30 09:16:51 1991
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

na = length(a);
nb = length(b);
aminus = a;
bminus = b;
if na>1,
  aminus(1,na-1:-2:1) = -a(1,na-1:-2:1);
end
if nb>1,
  bminus(1,nb-1:-2:1) = -b(1,nb-1:-2:1);
end

loc = rootloc(conv(b,bminus),conv(a,aminus),r1,r2,dsmax);

% sort out stable roots

[n,m] = size(loc);
locus = [];
for k = 1:n,
  [imvec,imindex] = sort(imag(loc(k,2:m)));
  loc(k,2:m) = loc(k,imindex+1);
  zindex = find(real(loc(k,2:m))==0);
  index = find(real(loc(k,2:m))<0);
  locus = [locus; loc(k,1) loc(k,index+1) loc(k,zindex(1:2:length(zindex))+1)];
end

rl = locus(:,2:size(locus)*[0;1]);

po = roots(conv(a,aminus));
[tmp,ind] = sort(real(po));
po = po(ind(1:length(ind)/2));
ze = roots(conv(b,bminus));
[tmp,ind] = sort(real(ze));
ze = ze(ind(1:length(ind)/2));
if nargin<6
  Re_max = max([max(real(rl)) real(po') real(ze')]);
  Re_min = min([min(real(rl)) real(po') real(ze')]);
  Im_max = max([max(imag(rl)) imag(po') imag(ze')]);
  dRe = Re_max - Re_min;
  dIm = 2*Im_max;
  mRe = (Re_min + Re_max)/2;
  d = max(dRe,dIm);
  if d==0
    w = [-abs(Re_max) abs(Re_max)]*1.2;
  else
    w = [-d/2 d/2]*1.2;
  end
  scale = [w+mRe w];
end

axis('square');
axis(scale);
plot(0,0,'i');
hold on;
plot(real(rl),imag(rl),'.w');
mark(ze,4,[],[],1);
mark(po,2,[],[],1);
xlabel('Re');
ylabel('Im');
hold off;
axis('normal');

