function locus = rloc1(b,a,k1,k2,dsmax,scale);
% RLOC1	Plots full rootlocus including start and end points
%
%	locus = rloc1(b,a,k1,k2,dsmax,scale)
%	locus = rloc1(b,a,k1,k2,dsmax)
%
%	Plots the root locus of a(s) + k*b(s) for k1 < k < k2. Also the 
%       roots of a (start points) and the roots of b (end points) are plotted.
%
%       The increments in k are chosen such that abs(ds) < dsmax.
%       The k-values and the roots are stored in locus, with the k-values
%       in the first column.
%
%	scale (optional) takes the form [xmax xmin ymin ymax]. If scale is 
%	omitted an attempt is done to find a plot scale that gives an aspect
%	ratio as close to 1 as possible.

% Kjell Gustafsson, derived from routines by Mats Lilja
% LastEditDate : Thu May 30 09:13:35 1991
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

locus = rootloc(b,a,k1,k2,dsmax);
rl = locus(:,2:size(locus)*[0;1]);
po = roots(a);
ze = roots(b);

if nargin<6
  Re_max = max([max(real(rl)) real(po') real(ze')]);
  Re_min = min([min(real(rl)) real(po') real(ze')]);
  Im_max = max([max(imag(rl)) imag(po') imag(ze')]);
  dRe = Re_max - Re_min;
  dIm = 2*Im_max;
  mRe = (Re_min + Re_max)/2;
  d = max(dRe,dIm);
  if d==0
    w = [-abs(Re_max) abs(Re_max)]*1.2;
  else
    w = [-d/2 d/2]*1.2;
  end
  scale = [w+mRe w];
end

axis('square');
axis(scale);
plot(0,0);
hold on;
plot(real(rl),imag(rl),'.w');
mark(ze,4,[],[],1);
mark(po,2,[],[],1);
xlabel('Re');
ylabel('Im');
hold off;
axis('normal');
