function pzpl(b,a,pmark,zmark,msize,scale)
% PZPL	pole-zero plot
%
%	pzpl(b,a,pmark,zmark,msize,scale)
%	pzpl(b,a,pmark,zmark,msize)
%	pzpl(b,a,pmark,zmark)
%	pzpl(b,a)
%
%	Plots the poles and zeros of the transfer function b(s)/a(s). Poles
% 	and zeros are marked with mark type pmark and zmark, respectively. 
%	Possible mark types are
%
%	1  plus         4  ring          7  hollow plus      10  natostar
%       2  cross        5  heart         8  smiley face
%       3  diamond      6  triangle      9  pentagon
%
%	If pmark and/or zmark are omitted or supplied as [] they default to 
%	2 (cross) and 4 (ring). The marks have the size msize which defaults 
%       to 0.01 if msize is omitted or supplied as [].
%
%	scale (optional) takes the form [xmax xmin ymin ymax]. If scale is 
%	omitted an attempt is done to find a plot scale that gives an aspect
%	ratio as close to 1 as possible.

% Mats Lilja (original)
% Kjell Gustafsson
% LastEditDate : Wed Sep  5 14:06:30 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if nargin<6
  r = [roots(b); roots(a)];
  Re_max = max(real(r));
  Re_min = min(real(r));
  Im_max = max(imag(r));
  dRe = Re_max - Re_min;
  dIm = 2*Im_max;
  mRe = (Re_min + Re_max)/2;
  d = max(dRe,dIm);
  if d==0
    w = [-abs(Re_max) abs(Re_max)]*1.2;
  else
    w = [-d/2 d/2]*1.2;
  end
  scale = [w+mRe w];
end

if nargin<3, pmark = 2; end
if nargin<4, zmark = 4; end
if nargin<5, msize = 0.01; end

if size(pmark)==[0 0], pmark = 2; end
if size(zmark)==[0 0], zmark = 4; end
if size(msize)==[0 0], msize = 0.01; end

%axis('square');
plot(0,0);
%mark(roots(b),zmark,msize,[],1);
%mark(roots(a),pmark,msize,[],1);
rb = roots(b);
ra = roots(a);
x1=scale(1);
x2=scale(2);
y1=scale(3);
y2=scale(4);
plot(real(rb),imag(rb),'o',real(ra),imag(ra),'x',[x1 x2],[0 0],'b',[0 0],[y1 y2],'b');
xlabel('Re');
ylabel('Im');
axis('square');
axis(scale);
