function [x1, y1] = plotline(x0, y0, r, angle)
% PLOTLINE plots a line
%
%	[x1,y1] = plotline(x0,y0,r,angle)
%
% 	A line of length r is plotted in direction angle from x0, y0. The 
%	endpoint is x1, y1. 

% Per Persson
% LastEditDate : Thu Jul  5 15:03:38 1990
% Copyright (c) 1990 by Per Persson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

hold on;
x1 = x0 + r*cos(angle);
y1 = y0 + r*sin(angle);
plot([x0 x1], [y0 y1]);
hold off;

