function res = plotcirc(rad, phi1, phi2, x, y, lt, ddeg)
% PLOTCIRC plot a circle segment
%
%	res = plotcirc(rad, phi1, phi2, x, y, lt, ddeg)
%
%	Plots a circle segment with radius rad from angle phi1 to phi2 with
%	center x, y. The linetype is lt and the angle increment in the plot
%	is ddeg. lt and ddeg are optional with default value '-' and 1,
%	respectively. The output argument res is the plotted circle segment.

% Per Persson
% LastEditDate : Thu May 30 09:10:43 1991
% Copyright (c) 1990 by Per Persson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if nargin<7, ddeg = 1; end;
if nargin<6, lt = '-'; end;

if phi2 < phi1, tmp = phi1; phi1 = phi2; phi2 = tmp; end;
tmp = [phi1:(ddeg*pi/180):phi2]';
res = rad*[cos(tmp) sin(tmp)];

hold on;
plot(res(:,1) + x, res(:,2) + y, lt);
hold off;



