function numbers(n,z)
% NUMBERS print numeric value in plot
%
%	numbers(n,z)
%
%       The numeric value n is printed at position z. If z is omitted it 
%	defaults to 0.

% Per Persson
% LastEditDate : Thu May 30 09:10:57 1991
% Copyright (c) 1990 by Per Persson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if nargin == 1, z = 0; end;
x = real(z);
y = imag(z);
pz = 0.01;
ax = axis;
axis;
r = pz*(ax(2) - ax(1)); 
for ix = (abs(sprintf('%g', n))),
  n = ix;
  hold on;  
  if n == 49,
    [x1, y1] = plotline(x, y, 1.5*r, pi/2);
    plotline(x1, y1, 0.3*r, 5*pi/4);
    x = x + 0.8*r;
  elseif n == 50,
    plot(x + [-r/2, r/2], y + [0, 0]);
    plot(x + [-r/2, r/(2*sqrt(2))], y + [0, r*(1 - 1/(2*sqrt(2)))]);
    plotcirc(r/2, -pi/4, pi, x, y + r, '-', 10);
    x = x + 1.1*r;
  elseif n == 51,
    plot(x + [-r/2, r/2, 0], y + [1.5*r, 1.5*r, r]);
    plotcirc(r/2, -pi, pi/2, x, y + r/2, '-', 10);
    x = x + 1.1*r;
  elseif n == 52,
    plot(x + [0, 0, -0.6*r, 0.35*r], y + [0, 1.5*r, 0.7*r, 0.7*r]);
    x = x + 0.75*r;
  elseif n == 53,
    plot(x + [-0.5*r/sqrt(2), -0.5*r/sqrt(2), r/2],...
         y + [r*(1/2 + 0.5/sqrt(2)), 1.5*r, 1.5*r]);
    plotcirc(r/2, -3*pi/4, 3*pi/4, x, y + r/2, '-', 10);
    x = x + 1.1*r;
  elseif n == 54,
    plot(x + [-r/2, -r/2], y + [r/2, r]);
    plotcirc(r/2, 0, 2*pi, x, y + r/2, '-', 10);
    plotcirc(r/2, pi/6, pi, x, y + r, '-', 10);
    x = x + 1.1*r;
  elseif n == 55,
    plot(x + [-0.35*r, 0.5*r, 0], y + [1.5*r, 1.5*r, 0]);
    x = x + r;
  elseif n == 56,
    plotcirc(r/2, 0, 2*pi, x, y + r/2, '-', 10);
    fi = acos(-((r/2)^2 - (0.35*r)^2 - (0.75*r)^2)/(2*(r*0.35)*(0.75*r)));
    plotcirc(0.35*r, pi + (pi/2 - fi), -(pi/2 - fi), x, y + 1.25*r, '-', 10);
    x = x + 1.1*r;
  elseif n == 57,
    plot(x + [r/2, r/2], y + [r/2, r]);
    plotcirc(r/2, 7*pi/6, 2*pi, x, y + r/2, '-', 10);
    plotcirc(r/2, 0, 2*pi, x, y + r, '-', 10);
    x = x + 1.1*r;
  elseif n == 48,
    plot(x + [(r/2), (r/2)], y + [(r/2), r]); 
    plot(x + [(-r/2), (-r/2)], y + [(r/2), r]);
    plotcirc(r/2, 0, -pi, x, y + r/2, '-', 10);
    plotcirc(r/2, 0, pi, x, y + r, '-', 10);
    x = x + 1.1*r;
  elseif n == 43,
    plot(x + [-0.5*r, 0.5*r], y + [0.55*r, 0.55*r]);
    plot(x + [0, 0], y + [0.2*r, 1.3*r]);
    x = x + 1.0*r;
  elseif n == 45,
    plot(x + [-0.5*r, 0.5*r], y + [0.55*r, 0.55*r]);
    x = x + 1.3*r;
  elseif n == 46,
    x = x - 0.3*r;
    plotcirc(0.1*r, 0, 2*pi, x, y);
    x = x + 0.8*r;
  elseif n == 101,
    x = x - 0.25*r;
    plot(x + [0.7*r, 0, 0, 0.7*r], y + [0, 0, r, r]);
    plot(x + [0, 0.6*r], y + [0.5*r, 0.5*r]);
    x = x + 1.3*r;
  end;
  hold off;
end;
