function derpol = derpoly(pol,n);
% POLYDER Differentiate polynomials
%
% 	derpol = derpoly(pol,n)
%
% 	Computes the n:th derivative of the polynomial pol. The argument
%	n is optional. It is taken as 1 if omitted.

% Kjell Gustafsson, stolen from Mats Lilja
% LastEditDate : Tue Sep  4 10:46:27 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if nargin == 1,
  n = 1;
end;
if n < 1,
  derpol = pol;
else,
  pol = derpoly(pol,n-1);
  np = length(pol)-1;
  nn = np:-1:0;
  derpol = nn.*pol;
  derpol = derpol(1:np);
end;
if length(derpol) < 1,
  derpol = 0;
end;
