function [tyu] = steprc(num,den,tmax,dt);
% STEPRC
%
%      [tyu] = steprc(num,den,tmax,dt)
%
% Calculates the step response of a system with the transfer function
%
%             num(s)
%     G(s) = --------
%             den(s)
%
% where tmax is the simulation time and dt is the time step.
%
t = [0:dt:tmax]';
u = ones(size(t));
y = stegsvar(num, den, 0, t);
tyu = [t y u];

