function [polystring] = polystr(p,letter,ndigits);
% polystr(p,letter,ndigits)
if nargin < 3,
  ndigits = 4;
end;
if nargin < 2,
  letter = 's';
end;
if sum(size(ndigits)) > 0,
  coefformat = sprintf('%%.%gg',ndigits);
else,
  coefformat = '%g';
end;
n = length(p);
polystring = [];
notfirstterm = 0;
for j=1:n,
  pj = p(j);
  if sign(pj) < 0,
    sgn = '- ';
  elseif sign(pj) > 0 & notfirstterm,
    sgn = '+ ';
  else,
    sgn = '';
  end;
  e = n - j;
  if abs(abs(pj)-1) < 5e-6 & e > 0,
    coefficient = '';
  else,
    coefficient = sprintf(coefformat,abs(pj));
  end;
  if e > 9,
    power = [letter sprintf('^<%g> ',e)];
  elseif e > 1,
    power = [letter sprintf('^%g ',e)];
  elseif e == 1,
    power = [letter ' '];
  else,
    power = '';
  end;
  if pj ~= 0,
    term = [sgn coefficient power];
    notfirstterm = 1;
  else,
    term = [];
  end;
  polystring = [polystring term];
end;
