function [tyu] = impulsrc(num,den,tmax,dt);
% STEPRC
%
%      [tyu] = impulsrc(num,den,tmax,dt)
%
% Calculates the impulse response of a system with the transfer function
%
%             num(s)
%     G(s) = --------
%             den(s)
%
% where tmax is the simulation time and dt is the time step.
%
t = [0:dt:tmax]';
y = impulse(num,den,t);
u = zeros(size(t));
u(1) = inf;
tyu = [t y u];

