function y = epolyval(c,e,x)
% EPOLYVAL Evaluation of extended polynomials
%
%        y = epolyval(c,e,x)
%
%        evaluates the extended polynomial
%
%            ---       e(j)
%         y = \  c(j) x
%             /   
%            ---
%
%        where the exponents may be arbitrary (e.g. non-integer).

% Mats Lilja
% LastEditDate : Thu Mar 21 14:40:58 1991
% Copyright (c) 1990 by Mats Lilja and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

[n,m] = size(x);
nc = length(c);
ne = length(e);
if nc ~= ne,
  error('Number of coefficients must coincide with number of exponents');
end;
y = zeros(n,m);
for j=1:nc,
  y = y + c(j)*x.^e(j);
end;
