function [kw,iw,dw] = pidgraph(b,a,tau,phim,w,scales,lintrans)
% [kw,dw,iw] = pidgraph(b,a,tau,phim,w)
% [kw,dw,iw] = pidgraph(b,a,tau,phim,w,scales)
% [kw,dw,iw] = pidgraph(b,a,tau,phim,w,scales,lintrans)
if nargin < 7,
  lintrans = [1 0];
end;
k = lintrans(1);
l = lintrans(2);
i = sqrt(-1);
w = w(:);
g = gval(b,a,tau,i*w);
gwo = -g.^(-1);
gwc = exp(i*phim*pi/180)*gwo;
kw = [real(gwc) real(gwo)];
iw = (2/pi)*atan(l + k*[imag(gwc)./real(gwc)./w imag(gwo)./real(gwo)./w]);
dw = (2/pi)*atan(l + k*[imag(gwc)./real(gwc).*w imag(gwo)./real(gwo).*w]);
if nargin < 6,
  scales = [];
end;
if max(size(scales)) == 0,
  minidw = min(min([iw,dw]));
  maxidw = max(max([iw,dw]));
  scales = [min(w) max(w) min(kw(:)) max(kw(:)) minidw maxidw];
end;
wsc = scales(1:2);
kwsc = scales(3:4);
idwsc = scales(5:6);
subplot;
axis([wsc kwsc]);
subplot(211);
plot(w,kw);grid;
xlabel('w');
subplot(212);
axis([wsc idwsc]);
plot(w,[iw dw]);
grid;
xlabel('w');
axis;

