function [wc,wo,K,Ti,Td,Am] = piddes(b,a,tau,phim,wmax,scales,lintrans)
% [wc,wo,K,Ti,Td] = piddes(b,a,tau,phim,w)
% [wc,wo,K,Ti,Td] = piddes(b,a,tau,phim,wmax,scales)
% [wc,wo,K,Ti,Td] = piddes(b,a,tau,phim,wmax,scales,lintrans)
if nargin < 7,
  lintrans = [1 0];
end;
k = lintrans(1);
l = lintrans(2);
i = sqrt(-1);
nw = 200;
w = wmax*[1:nw]'/nw;
g = gval(b,a,tau,i*w);
gwo = -g.^(-1);
gwc = exp(i*phim*pi/180)*gwo;
kw = [real(gwc) real(gwo)];
iw = (2/pi)*atan(l + k*[imag(gwc)./real(gwc)./w imag(gwo)./real(gwo)./w]);
dw = (2/pi)*atan(l + k*[imag(gwc)./real(gwc).*w imag(gwo)./real(gwo).*w]);
if nargin < 6,
  scales = [];
end;
if length(scales) == 0,
  minidw = min(min([iw,dw]));
  maxidw = max(max([iw,dw]));
  scales = [min(w) max(w) min(kw(:)) max(kw(:)) minidw maxidw];
end;
wsc = scales(1:2);
kwsc = scales(3:4);
idwsc = scales(5:6);
subplot;
axis([wsc kwsc]);
subplot(211);
plot(w,kw);grid;
xlabel('w');
subplot(212);
axis([wsc idwsc]);
plot(w,[iw dw]);
grid;
xlabel('w');
axis;
[wc,zzzz] = ginput(1);
[wo,zzzz] = ginput(1);
[K,Ti,Td,Am] = pidpara(b,a,tau,phim,wc,wo);
