function [R,S,T] = pid2rst(K,Ti,Td,N,beta,betad)
% [R,S,T] = pid2rst(K,Ti,Td,N,beta,betad)
if nargin == 1,
  [nrow,ncol] = size(K);
  if ncol < 6,
    error('Too few parameters');
  end;
  pidpar = K;
  betad = pidpar(:,6);
  beta = pidpar(:,5);
  N = pidpar(:,4);
  Td = pidpar(:,3);
  Ti = pidpar(:,2);
  K = pidpar(:,1);
end;
K = K(:);
Ti = Ti(:);
Td = Td(:);
N = N(:);
beta = beta(:);
betad = betad(:);
[K,Ti,Td,N,beta,betad];
if any(Td < 0),
  disp('Negative derivative time ==> Changing sign of filter factor');
  N = sign(Td).*N;
end;
one = K.^0;
R = [one N./Td 0*one];
S = [K.*(N+1) K.*(N./Td+(1)./Ti) K.*(N./Ti./Td)];
T = [K.*(N.*betad+beta) K.*(beta.*N./Td+(1)./Ti) K.*(N./Ti./Td)];
