function [s,r,wc,phim] = leadcmp(fr,wc_new,phim_new,zeta,maxlead)
% LEADCMP Compute a lead compensator from a frequency response
%
%       [S,R] = LEADCMP(FR,WC_NEW,PHIM_NEW)
%
%       [S,R,WC_OLD,PHIM_OLD] = LEADCMP(FR,WC_NEW,PHIM_NEW)
%
%       [S,R,WC_OLD,PHIM_OLD] = LEADCMP(FR,WC_NEW,PHIM_NEW,ZETA,MAXLEAD)
%

% Mats Lilja
% Copyright (c) 1990 by Mats Lilja and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if nargin < 5,
  maxlead=90;
end;
if nargin < 4,
  zeta = 1;
end;
w = fr(:,1);
g = fr(:,2);
[wc,phi1] = ampcross(fr,1);
phim = 180 + phi1;
wc2 = wc_new;
gwc2 = table1([w abs(g) arg(g)],wc2);
amp2 = gwc2(1);
phi2 = gwc2(2);
phi2_new = phim_new - 180;
dphi = phi2_new - phi2;
if zeta == 1,
  order = ceil(dphi/maxlead);
  th = pi*(dphi/order+90)/360;
  N = (tan(th))^2;
  b = wc2/sqrt(N);
  r = poly(-N*b*ones(1,order));
  s = poly(-b*ones(1,order))*(sqrt(N))^order/amp2;
else,
  order2 = ceil(dphi/maxlead/2);
  th = pi*(dphi/order2)/360;
  alfa = zeta*tan(th);
  N = (alfa+sqrt(1+alfa^2))^2;
  b = wc2/sqrt(N);
  one2 = ones(1,order2);
  r = polyc(N*b*one2,zeta*one2);
  s = polyc(b*one2,zeta*one2)*(N^order2)/amp2;
end;
