function fr = svcss(a,b,c,d,lgw1,lgw2,n)
% SVCSS Computes the singular value frequency response of a
%       continuous time MIMO state space system.
%
%       fr = svcss(a,b,c,d,lgw1,lgw2,n)
%       fr = svcss(a,b,c,d,wvec)
%
%       The maximum and miminum singular values for
%	G(s) = ( c (sI-a)^(-1)  b + d ) is calculated either for the 
%	frequencies in wvec [rad/s] or for n logarithmically spaced 
%	frequency points [rad/s] between 10^lgw1 and 10^lgw2. The 
%	argument n is optional with default value 50.
%
%       The output fr takes the form  [ w sigma_max(w) sigma_min(w) ].


% Michael Lundh (original)    
% LastEditDate : Mon Jun 25 16:19:00 1990
% Copyright (c) 1990 by Michael Lundh and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if nargin==7
  w = logspace(lgw1,lgw2,n);
elseif nargin==6
  w = logspace(lgw1,lgw2);
else 
  w = lgw1(:);
end

i = sqrt(-1);

error(abcdchk(a,b,c,d));
[no,ns] = size(c);
ni = size(b)*[0;1];

% Balance A
[t,a] = balance(a);
b = t \ b;
c = c * t;

% Reduce A to Hessenberg form
[p,a] = hess(a);
c = c*p;

gg = [];
for iu=1:ni
  g = ltifr(a,p'*b(:,iu),i*w);
  g = c*g + diag(d(:,iu)) * ones(no,length(w));
  gg = [gg g.'];
end;

%---- now sorted G11 G21 G31 .. G12 G22 .. .. Gmn  -- calculate sv
fr = [];
for ii=1:length(w)
  giw=gg(ii,1:no)';
  for j=2:ni
    giw=[giw gg(ii,(1+no*(j-1)):(no*j))'];
  end
  sv=svd(giw);
  fr=[fr ; w(ii) max(sv) min(sv)];
end
