function phpl(fr1,fr2,fr3,fr4,scale)
% PHPL  Plot the phase of a frequency response.
%
%       phpl(fr1,fr2,fr3,fr4,scale)
%
%       An phase plot is done from the frequency responses in fr1 - fr4. 
%       The arguments fr2 - fr4 are optional. fr1 - fr4 is allowed to have
%       different number of data points and columns.
%
%	The optional argument scale is used to affect the scaling of the 
%       plot. It takes the form [wmin wmax phmin phmax]. wmin and wmax 
%       are given in 10-logarithm, i.e. wmin = -1, wmax = 2 corresponds to 
%	a frequency scale from 0.1 to 100. scale can be used even if fr2 - 
%	fr4 are omitted.
%
%       The scale of the phase plot is stored in the variable glob_scale,
%       which must be declared as global. The scale is used to be able to 
%       draw (using PHSH) consecutive plots in the same diagram.
%
%       The frequency axis will be marked in Hz if the global variable
%	glob_hz has a value differing from 0.

% Kjell Gustafsson    
% LastEditDate : Wed Mar  7 14:53:52 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

%if frcheck, return, end
glob_hz=0;

if nargin~=5
  scale = eval(['fr' int2str(nargin)]);
end
scaleinfo = all(size(scale) == [1 4]);

ind = sprintf('(:,2:%g)',size(fr1)*[0;1]);
if glob_hz,
  plotpha = ['semilogx(fr1(:,1)/(2*pi),arg(fr1' ind ')'];
else
  plotpha = ['semilogx(fr1(:,1),arg(fr1' ind ')'];
end

for k=2:nargin-scaleinfo,
  kstr = int2str(k);
  eval(['ind = sprintf(''(:,2:%g)'',size(fr' kstr ')*[0;1]);'])
  if glob_hz,
    plotpha = [plotpha ',fr' kstr '(:,1)/(2*pi),arg(fr' kstr ind ')'];
  else
    plotpha = [plotpha ',fr' kstr '(:,1),arg(fr' kstr ind ')'];
  end
end
plotpha = [plotpha ');'];

subplot(111);
if scaleinfo, axis(scale); end
eval(plotpha);
glob_scale = axis;
if ~scaleinfo, axis; end

ylabel('Phase [deg]');
if glob_hz,
  xlabel('Frequency [Hz]');
else
  xlabel('Frequency [rad/s]');
end
