function nysh(fr,wmark,option)
% NYSH	Show a Nyquist plot in a previously drawn Nyquist diagram.
%
%       nysh(fr,wmark,option)
%       nysh(fr,[],option)
%       nysh(fr,wmark)
%       nysh(fr)
%
%       A Nyquist plot is done from the frequency responses in fr using
%       the plotoption option. The argument option is optional.
%
%       The frequency points in wmark are marked in the plot. If wmark is 
%       omitted or has the value [] no marking is done. If wmark equals
%       '125' then the 1, 2 and 5 frequency points in each decade are marked 
%       with +, *, and o, respectively. Due to numerics it may happen that 
%       end points are not marked. If the global variable glob_hz has a value 
%       differing from 0, then the marked points will be in [Hz] while in 
%       [rad/s] otherwise.

% Kjell Gustafsson    
% LastEditDate : Fri Mar 30 08:26:48 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

%%%if frcheck, return, end
global glob_hz;
global glob_scale;

if nargin>1
  markinfo = size(wmark)~=[0 0];
else
  markinfo = 0;
end

% Calulate the markings.

if markinfo
  if ~isstr(wmark)
    ptemp = table1(fr,wmark);
    if size(ptemp)~=[0 0]
      p = ptemp(:);
    else
      p = [];
    end
  else
    wmin = min(fr(:,1));
    wmax = max(fr(:,1));
    if glob_hz,
      dec = 2*pi*exp(log(10)*(floor(log10(wmin/(2*pi))):ceil(log10(wmax/(2*pi))))');
    else
      dec = exp(log(10)*(floor(log10(wmin)):ceil(log10(wmax)))');
    end
    w1 = dec;
    w2 = 2*dec;
    w5 = 5*dec;
    ptemp = table1(fr,w1(find((w1 >= wmin) & (w1 <= wmax))));
    if size(ptemp)~=[0 0]
      p1 = ptemp(:);
    else
      p1 = [];
    end
    ptemp = table1(fr,w2(find((w2 >= wmin) & (w2 <= wmax))));
    if size(ptemp)~=[0 0]
      p2 = ptemp(:);
    else
      p2 = [];
    end
    ptemp = table1(fr,w5(find((w5 >= wmin) & (w5 <= wmax))));
    if size(ptemp)~=[0 0]
      p5 = ptemp(:);
    else
      p5 = [];
    end
  end
end

ind = size(fr)*[0;1];

axis('square');
hold on;
if nargin~=3
  plot(real(fr(:,2:ind)),imag(fr(:,2:ind)));
else
  plot(real(fr(:,2:ind)),imag(fr(:,2:ind)),option);
end
if markinfo
  if ~isstr(wmark)
    plot(p,'xw') 
  else
    plot(p1,'+w')
    plot(p2,'*w')
    plot(p5,'ow')
  end
end
hold off;
axis('normal');
