function z = mpcirc(mp,n);
% MPCIRC Calculates mp-circles.
%
%	z = mpcirc(mp,n)
%
%       Calculates mp-circles corresponding to the values in the row 
%       vector mp. n states the number of points on each circle. n is
%       optional, and if not given taken as 40.

% Kjell Gustafsson
% LastEditDate : Wed Mar  7 14:52:31 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if nargin == 1,
  n = 40;
end
i = sqrt(-1);
uc = exp(i*(0.00001:2*(pi-0.000011)/(n-1):(2*pi-0.00001)))';
ucs = kron(uc,mp);
z = ucs./(ones(ucs) - ucs);
