function [xcross,zvalues] = levcross(table,level)
% LEVCROSS Compute level crossings in a table
%
%       XCROSS = LEVCROSS(TABLE,LEVEL)
%
%       Given a two column table TABLE, [ X  Y ], all values in X
%       for which Y crosses LEVEL are computed.
%
%       If TABLE consists of three or more columns [ X  Y  Z ] 
%
%       [XCROSS,ZVALUES] = LEVCROSS(TABLE,LEVEL)
%
%       gives the corresponding values of Z as well

% Mats Lilja
% LastEditDate : Mon Jun 25 17:25:56 1990
% Copyright (c) 1990 by Mats Lilja and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

x = table(:,1);
y = table(:,2);
[nrows,ncols] = size(table);
z = table(:,3:ncols);
err = y - level;
indices = find(diff(sign(err))~=0);
if length(indices)<1,
  disp('No crossing of this level');
end;
xcross = [];
zvalues = [];
for ind1=indices',
  ind2 = min([length(x),ind1+1]);
  yxz = [y x z];
  yxz1 = yxz(ind1:ind2,:);
  xz = table1(yxz1,level);
  xcross = [xcross ; xz(1)];
  zvalues = [zvalues ; xz(2:ncols-1)];
end;
