function fr = id2fr(idfr)
% ID2FR Convert Identification Toolbox frequency files to FRBOX format
%
%       FR = ID2FR(IDFR)
%
%       Convert an Identification Toolbox frequency file IDFR 
%       to the format [omega G].

% Mats Lilja
% LastEditDate : Tue Mar 20 10:53:51 1990
% Copyright (c) 1990 by Mats Lilja and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

[nrows,ncols] = size(idfr);
idfr1 = idfr(1,:);
idfr2 = idfr(2:nrows,:);
freqind = find(idfr1 > 100);
ampind = find(idfr1 < 20);
phaind = find(idfr1 > 10 & idfr1 < 50);
nfre = length(freqind);
namp = length(ampind);
npha = length(phaind);
if max(abs([nfre-namp,nfre-npha])) > 0,
  error('Different number of frequency, amplitude or phase columns');
end;
nfre = length(freqind);
if nfre > 1,
  disp('Picking all frequency responses with the same frequency column');
  disp('as the first frequency response.');
end;
omega = idfr2(:,freqind);
omega1 = omega(:,1);
ind = freqind(1);
for j=2:nfre,
  if sum(abs(omega1-omega(:,j))) < eps,
    ind = [ind idfr1(freqind(j))-100];
  end;
end;
npicked = length(ind);
if npicked == 1,
  pluralis = [];
else,
  pluralis = 's';
end;
disp([sprintf('%g frequency response',npicked) pluralis ' picked.']);
fr = omega1;
for k=ind,
  aind = find(idfr1==k);
  ampk = idfr2(:,aind);
  pind = find(idfr1==20+k);
  phak = idfr2(:,pind);
  fr = [fr ampk.*exp(sqrt(-1)*phak*pi/180)];
end;
