function gvec = gval(b,a,tau,wvec)
% GVAL  evaluates a set of transfer functions at a vector of frequency points
%
%       gvec = gval(b,a,tau,wvec)
%
%       The value of G(s) = b(s)/a(s)*exp(-tau*s) is calculated for 
%       the complex frequency points in wvec [rad/s]. The frequency reponse
%	can be calculated for several transfer functions by making  b, a, 
%	and tau contain several rows. Column k in gvec corresponds to row k 
%	in a, b, and tau. If a, b, or tau is given as a single value while
%       the other parameters contain several rows then this single value will
%       be used for all the rows in the other parameters.

% Kjell Gustafsson     
% LastEditDate : Wed Mar  7 14:52:14 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

na = size(a)*[1;0];
nb = size(b)*[1;0];
nt = length(tau);
maxn = max([na nb nt]);

if [na nb nt]==maxn | [na nb nt]==1
  if na==1, a = ones(maxn,1)*a; end
  if nb==1, b = ones(maxn,1)*b; end
  if nt==1, tau = ones(maxn,1)*tau; end 
else
  error('Inconsistent number of rows in a, b, and tau')
end

gvec = zeros(length(wvec),maxn);   % reserve space in advance for speed

for k=1:maxn,
  gvec(:,k) = ...
    exp(-tau(k)*wvec(:)).*polyval(b(k,:),wvec(:))./polyval(a(k,:),wvec(:));
end
