function fr = fsens(fro)
% FSENS Calculates the sensitivity frequency response corresponding
%	to the loop transfer fro.
%
% 	fr = fsens(fro)

% Kjell Gustafsson
% LastEditDate : Wed Mar  7 14:51:55 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

[n,m] = size(fro);
fr = [fro(:,1) ones(fro(:,2:m))./(1+fro(:,2:m))];
