function fr=frdsys(sys,nsys,tsamp,lgw1,lgw2,n)
% FRDSYS Computes the frequency response of a discrete time MIMO system.
%
%       fr = frdsys(sys,nsys,tsamp,lgw1,lgw2,n)
%       fr = frdsys(sys,nsys,tsamp,lgw1,[],n)
%       fr = frdsys(sys,nsys,tsamp,lgw1)
%       fr = frdsys(sys,nsys,tsamp,wvec)
%
%       The value of H(q) = c (qI-a)^(-1) b + d is calculated either for the 
%	frequencies in wvec [rad/s] or for n logarithmically spaced frequency 
%	points [rad/s] between 10^lgw1 and 10^lgw2. The argument n is optional
%	with default value 50. If lgw2 is supplied as an empty matrix or 
%	omitted it is taken as half the sampling frequency (pi/tsamp).
%
%	sys is a system description on the form [a b; c d] with nsys as the
%       number of states.
%
%       The output fr takes the form 
%	[ w  H11(exp(iw*tsamp)) H12(exp(iw*tsamp)) ... Hmn(exp(iw*tsamp)] 
%	where Hij corresponds to the transfer function from input j to 
%       output i.

% Kjell Gustafsson
% LastEditDate : Wed Mar  7 14:50:39 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

[na,ma]=size(sys);

a = sys(1:nsys,1:nsys);
b = sys(1:nsys,(nsys+1):ma);
c = sys((nsys+1):na,1:nsys);
d = sys((nsys+1):na,(nsys+1):ma);

if nargin==6
  fr = frdsys(a,b,c,d,tsamp,lgw1,lgw2,n);
elseif nargin==5
  fr = frdsys(a,b,c,d,tsamp,lgw1,lgw2);
else
  fr = frdsys(a,b,c,d,tsamp,lgw1)
end
