% Kjell Gustafsson
% LastEditDate : Thu Jul 19 11:10:10 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

frbox
echo on
clc
%	This example demonstrates some of the functions in FRBOX

%	Through out the example we will use the process G = 2/(s+1)*exp(-s)
%	Let's start by calculating its frequency response.

fp = frc(2,[1 1],1,-1,1);

pause 	% Strike RETURN to make a Bode plot of G

bopl(fp)
title('Bode plot for the process G = 2/(s+1)*exp(-s)'), pause

pause	% Strike RETURN to add grid

bogrid, pause

clc
%	Calculate the gain and phase margin of the process

[gm,phm,wgm,wphm] = fmarg(fp)

pause	% Strike RETURN to continue

clc
%	Use Ziegler-Nichols to calculate PID parameters

k = 0.6*gm, ti = 2*pi/wgm/2, td = ti/4,

pause 	% Strike RETURN to continue

clc
%	We want to investigate the closed loop system when using the
%	PID controller.	Calculate the frequency response for the PID 
%	controller, but vary the gain by 25 % around its nominal value.

[fy,fr] = frcpid(k*[0.75; 1; 1.25],ti,td,5,1,-1,1);

%	The PID controller has two different frequency responses; one from
%	measured value and one from reference value. We start by making
%	a Bode plot of the response from measured value. For completeness
%	we also include the response of the process.

pause 	% Strike RETURN for Bode plot

bopl(fy,fp), 
title('Bode plot of PID controller, k = [0.75 1 1.25]*knom'), pause

%	We also want to see the response from reference value. To compare 
%	we add it in the current diagram.

pause	% Strike RETURN to add response from reference value

bosh(fr), pause

clc
%	By using FMUL we can calculate the loop gain. We plot it in
%	a Nichols plot.

pause	% Strike RETURN for a Nichols plot of the loop gain

nipl(fmul(fy,fp))
title('Nichols plot of the loop gain'),  pause

%	The plot scales aren't too good, so we make a new plot with different
%	scaling. We also mark the frequency corresponding to process phase lag
%	equal to -180 degrees.

pause 	% Strike RETURN for a new Nichols plot

nipl(fmul(fy,fp),wgm,[-200 0 -1 1])
title('Nichols plot of the loop gain'),  pause

pause 	% Strike RETURN to add grid and Mp-circles 

nigrid, pause

clc
% 	Make a Bode plot of the sensitivity function

pause	% Strike RETURN for a Bode plot of the sensitivity function

bopl(fsens(fmul(fp,fy)))
title('Bode plot of sensitivity function'), pause

clc
% 	When evaluating control systems there is a number of different 
%	transfer functions worth investigating. EVPL is a routine that 
%	plots some of them. For futher information consult the help text
%	of EVPL

pause	% Strike RETURN for an evaluation plot

evpl(fp,fy,fr), pause

pause	% Strike RETURN to end

echo off
subplot
