function fr=frcsys(sys,nsys,tau,lgw1,lgw2,n)
% FRCSYS Computes the frequency response of a continuous time MIMO system.
%
%       fr = frcsys(sys,nsys,tau,lgw1,lgw2,n)
%       fr = frcsys(sys,nsys,tau,wvec)
%
%       The value of G(s) = ( c (sI-a)  b + d )*exp(-tau*s) is calculated 
%	either for the frequencies in wvec [rad/s] or for n logarithmically 
%	spaced frequency points [rad/s] between 10^lgw1 and 10^lgw2. The 
%	argument n is optional with default value 50.
%
%	sys is a system description on the form [a b; c d] with nsys as the
%       number of states.
%
%       The output fr takes the form  [  w   G11(iw) G12(iw) ... Gmn(iw) ]
%       with Gij as the transfer function from input j to output i.

% Kjell Gustafsson
% LastEditDate : Wed Apr  4 09:09:41 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

[na,ma]=size(sys);

a = sys(1:nsys,1:nsys);
b = sys(1:nsys,(nsys+1):ma);
c = sys((nsys+1):na,1:nsys);
d = sys((nsys+1):na,(nsys+1):ma);

if nargin==6
  fr = frcss(a,b,c,d,tau,lgw1,lgw2,n);
elseif nargin==5
  fr = frcss(a,b,c,d,tau,lgw1,lgw2);
else
  fr = frcss(a,b,c,d,tau,lgw1);
end
