function fr = frc(b,a,tau,lgw1,lgw2,n)
% FRC   Computes the frequency response of a continuous time 
%       transfer function.
%
%       fr = frc(b,a,tau,lgw1,lgw2,n)
%       fr = frc(b,a,tau,wvec)
%
%       The value of G(s) = b(s)/a(s)*exp(-tau*s) is calculated either for
%	the frequencies in wvec [rad/s] or for n logarithmically spaced 
%	frequency points [rad/s] between 10^lgw1 and 10^lgw2. The argument 
%	n is optional with default value 50. 
%
%    	If b, a, and tau contain several rows the frequency response will be
%	calculated for each triplet b(i,:), a(i,:), and tau(i).
%
%       The output fr takes the form [ w  G1(iw) G2(iw) ... ] where Gi 
%       corresponds to row i of a, b, and tau.

% Kjell Gustafsson     
% LastEditDate : Wed Mar  7 14:49:05 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

i = sqrt(-1);

if nargin==6
  w = logspace(lgw1,lgw2,n)';
elseif nargin==5
  w = logspace(lgw1,lgw2)';
else
  w = lgw1(:);
end

fr = [w gval(b,a,tau,i*w)];
