% FRBOX	-- A collection of routines to generate, plot, and manipulate
%          the frequency response of a system. Written by Kjell Gustafsson
%          and Michael Lundh, but in most cases originating from Mats Lilja.
%
% Generate
%
%    FRC, FRD        - frequency response from polynomial description
%    FRCSS, FRDSS    - frequency response from state space description
%    FRCSYS, FRDSYS  - frequency response from system description
%    FRCPID, FRDPID  - frequency response of PID controller
%    FRTUST          - frequency response of Tustin approximation
%    FRCASYMP        - amplitude asymptots from polynomial description
%    SVCSS           - singular value response from state space description
%    SVCSYS          - singular value response from system description
%
%    A frequency response is represented as a matrix [ w G1(i*w) G2(i*w) ... ]
%    with w in rad/s.
%
% Plot
%
%    BOPL, BOSH, BOGRID  - Bode plot
%    AMPL, AMSH, AMGRID  - amplitude plot
%    PHPL, PHSH, PHGRID  - phase plot
%    NYPL, NYSH, NYGRID  - Nyquist plot
%    NIPL, NISH, NIGRID  - Nichols plot
%    EVPL, EVSH, EVGRID  - plots to help evaluate a closed loop system
%
%    The *PL routines plot a new diagram from 1 up to 4 frequency responses.
%    A *SH routine adds to a previous plot, and *GRID plots grid and markings.
%
% Manipulate
%
%    FINV                    - invert a frequency response
%    FADD, FSUB, FMUL, FDIV  - various connections of two systems 
%    FCLOS, FOPN, FSENS    - closed loop, open loop, and sensitivity function
%    FLOG0, FLOG1            - logarithmic transformations
%
% Extracting data 
%
%    FPICK                         - pick out points from frequency response
%    LEVCROSS, AMPCROSS, PHACROSS  - compute level crossings
%    FMARG                         - amplitude and phase margin
%    BWIDTH                        - 3 dB bandwidth
%
% Conversion
%
%    ID2FR   - System Identification Toolbox data format to FRBOX format
%
% Miscellaneous
%
%    Some global variables are used. They are defined by executing FRBOX.
%    The names of the global variables start by 'glob_'. The frequency
%    plotting scale will be marked in Hz if the variable glob_hz has a 
%    value different from 0 or [].
%    Try FRDEMO
%
% Bugs
%
%    Sometimes different (and erroneous) scaling on screen and in meta file.
%    Normally taken care of by using a larger plot window on screen. 
%
%    Sometimes MATLAB chooses scales that one can not get through the axis
%    command. It is then impossible to add new curves with the *SH commands.
%
%    When using routines that plots in several plot windows you will be left 
%    in a window different from 111. This is an inconvenience but has to be
%    done since subplot(111) empties the plot buffer, i.e. no hard copies.

% Kjell Gustafsson
% LastEditDate : Thu May 30 09:08:59 1991
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

global glob_scale;
global glob_hz;
