function fr_picked = fpick(fr,omega)
% FPICK Picks out values at certain frequencies of a frequency response.
%
%       FR_PICKED = FPICK(FR,OMEGA)
% 
%       Makes linear interpolation in the frequency response FR at
%       the frequencies OMEGA. Frequencies in OMEGA outside the frequency
%       interval of FR are skipped and a warning text will appear.

% Mats Lilja
% LastEditDate : Tue Mar 13 14:29:14 1990
% Copyright (c) 1990 by Mats Lilja and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

w = sort(omega(:));
w_min = min(fr(:,1));
w_max = max(fr(:,1));
skip = find(w<w_min | w>w_max);
if sum(size(skip)) > 0,
  disp('Skipping frequencies outside the frequency interval:');
  skipped_frequencies = w(skip),
  w(skip) = [];
end;
g = table1(fr,w);
fr_picked = [w g];
