function fro = fopn(frc)
% FOPN Calculates the frequency response of the loop transfer
%	corresponding to a closed loop frequency response frc.
%
% 	fro = fopn(frc)

% Kjell Gustafsson
% LastEditDate : Mon Mar 26 10:50:11 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

[n,m] = size(frc);
fro = [frc(:,1) frc(:,2:m)./(1-frc(:,2:m))];
