function lfr = flog1(fr,n)
% FLOG1 Makes a logarithmic mapping of a frequency response
%
%       lfr = flog1(fr)
%       lfr = flog1(fr,n)
%
%       The mapping
%
%                      1 + z
%            w = -1 + ------- log(1 + |1 + z|)/log(2)
%                     |1 + z|
%
%       is applied n (default=1) times to the frequency response fr.
%       Fixed points are -1 and the circle with radius 1 and center -1.
%       Useful for Nyquist plots. Compare with flog0.

% Mats Lilja
% LastEditDate : Wed Feb 27 17:58:50 1991
% Copyright (c) 1990 by Mats Lilja and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if nargin < 2,
  n = 1;
end;
[nr,nc] = size(fr);
w = fr(:,1);
lg = fr(:,2:nc);
for j=1:n,
  lg = -1 + (1+lg)./abs(1+lg).*log(1+abs(1+lg))/log(2);
end;  
lfr = [w lg];
