function lfr = flog0(fr,n)
% FLOG0 Makes a logarithmic mapping of a frequency response
%
%       lfr = flog0(fr)
%       lfr = flog0(fr,n)
%
%       The mapping
%
%                 z
%            w = --- log(1 + |z|)/log(2)
%                |z|
%
%       is applied n (default=1) times to the frequency response fr.
%       Fixed points are 0 and the unit circle. Useful for Nyquist plots
%       since -1 is a fixed point. Compare with flog1.

% Mats Lilja
% LastEditDate : Wed Feb 27 17:52:48 1991
% Copyright (c) 1990 by Mats Lilja and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if nargin < 2,
  n = 1;
end;
[nr,nc] = size(fr);
w = fr(:,1);
lg = fr(:,2:nc);
for j=1:n,
  lg = lg./abs(lg).*log(1+abs(lg))/log(2);
end;  
lfr = [w lg];
