function lfr = flog(fr,n,fixptcirc)
% lfr = flog(fr)
% lfr = flog(fr,n)
% lfr = flog(fr,n,fixptcirc)
if nargin < 3,
  fixptcirc = [0 1];
end;
if nargin < 2,
  n = 1;
end;
[nr,nc] = size(fr);
w = fr(:,1);
lg = fr(:,2:nc);
center = fixptcirc(1);
radius = fixptcirc(2);
for j=1:n,
  z = lg - center;
  lg = center + z./abs(z).*log(1+abs(z))/log(1+radius);
end;  
lfr = [w lg];
