function fr = fclos(fro)
% FCLOS Calculates the frequency response of the closed loop system
%	resulting from unity gain feedback of the loop transfer fro.
%
% 	fr = fclos(fro)

% Kjell Gustafsson
% LastEditDate : Wed Mar  7 14:47:45 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

[n,m] = size(fro);
fr = [fro(:,1) fro(:,2:m)./(1+fro(:,2:m))];
