function evsh(gp,gfb,gff,gl,gn,gz,option)
% EVSH	shows new frequency responses in a previous plot by EVPL
%
%       evsh(gp,gfb,gff,gl,gn,gz,option)
%       evsh(gp,gfb,gff,gl,gn,option)
%       evsh(gp,gfb,gff,gl,option)
%       evsh(gp,gfb,gff,option)
%
%       Three plots depicting the transfer functions from r to y (or z), from
%       l to y (or z), and from n to u are plotted. The fourth plot shows
%       a measure of how much multiplicative uncertainty the loop may sustain
%       without becoming unstable.
%
%       The noise and load disturbance inputs can be weighted by supplying
%       gl and/or gn. A nonempty gz tells that the evaluation should be done
%	using z rather than y. gl, gn, and gz are all optional. The value []
%       is interpreted as 1.
%
%	The curves are plotted using the optional argument option. The plot
%       scales are taken from the global variable glob_scale.
%
%       The frequency axis will be marked in Hz if the global variable
%	glob_hz has a value differing from 0.
%
%                             | l    
%                             |     
%                             v    
%                          -------       --------
%                          |     |       |      |           z
%                          | Gl  |   --->|  Gz  |-------------
%                          |     |   |   |      |
%                          -------   |   --------
%                             |      |
%              ---------      |      |   ---------
%         r    |       |      v   u  |   |       |          y
%         ---->|  Gff  |----->+--------->|  Gp   |------------
%              |       |      ^          |       |      |
%              ---------      |          ---------      |
%                             |                         |
%                             |          ---------      |    ---------     
%                             |          |       |      v    |       |   n 
%                             -----------| -Gfb  |<-----+<---|  Gn   |<--- 
%                                        |       |           |       |     
%                                        ---------           ---------     

% Kjell Gustafsson
% LastEditDate : Thu Mar 15 14:59:51 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if frcheck, return, end

if ~all(size(glob_scale)==[4 4])
  error('No previous evaluation plot');
end

if nargin==7
  nogl = all(size(gl)==[0 0]);
  nogn = all(size(gn)==[0 0]);
  nogz = all(size(gz)==[0 0]);
elseif nargin==6
  nogl = all(size(gl)==[0 0]);
  nogn = all(size(gn)==[0 0]);
  if isstr(gz)
    nogz = 1;
    option = gz;
  else
    nogz = all(size(gz)==[0 0]);
    option = '0';
  end
elseif nargin==5
  nogl = all(size(gl)==[0 0]);
  if isstr(gn)
    nogn = 1;
    option = gn;
  else
    nogn = all(size(gn)==[0 0]);
    option = '0';
  end
  nogz = 1;
elseif nargin==4
  if isstr(gl)
    nogl = 1;
    option = gl;
  else
    nogl = all(size(gl)==[0 0]);
    option = '0';
  end
  nogn = 1;
  nogz = 1;
else
  nogl = 1;
  nogn = 1;
  nogz = 1;
  option = '0';
end

gloop = fclos(fmul(gp,gfb));

if nogz
  gzr = fmul(gloop,fdiv(gff,gfb));
else
  gzr = fmul(fmul(gloop,fdiv(gff,gfb)),fdiv(gz,gp));
end

if nogl
  gzl = fdiv(gzr,gff);
else
  gzl = fmul(gzr,fdiv(gl,gff));
end

% The following calculations have the wrong sign, but since we only
% will plot the magnitude that does not matter.

if nogn
  gun = fdiv(gloop,gp);
else
  gun = fmul(gloop,fdiv(gn,gp));
end

grob = finv(gloop);

subplot(221);
axis(glob_scale(1,:));
ind = size(gzr)*[0;1];
if glob_hz
  if option=='0'
    loglog(gzr(:,1)/(2*pi),abs(gzr(:,2:ind)));
  else
    loglog(gzr(:,1)/(2*pi),abs(gzr(:,2:ind)),option);
  end    
else
  if option=='0'
    loglog(gzr(:,1),abs(gzr(:,2:ind)));
  else
    loglog(gzr(:,1),abs(gzr(:,2:ind)),option);
  end    
end

subplot(222);
axis(glob_scale(2,:));
ind = size(gzl)*[0;1];
if glob_hz
  if option=='0'
    loglog(gzl(:,1)/(2*pi),abs(gzl(:,2:ind)));
  else
    loglog(gzl(:,1)/(2*pi),abs(gzl(:,2:ind)),option);
  end    
else
  if option=='0'
    loglog(gzl(:,1),abs(gzl(:,2:ind)));
  else
    loglog(gzl(:,1),abs(gzl(:,2:ind)),option);
  end    
end

subplot(223);
axis(glob_scale(3,:));
ind = size(gun)*[0;1];
if glob_hz
  if option=='0'
    loglog(gun(:,1)/(2*pi),abs(gun(:,2:ind)));
  else
    loglog(gun(:,1)/(2*pi),abs(gun(:,2:ind)),option);
  end    
else
  if option=='0'
    loglog(gun(:,1),abs(gun(:,2:ind)));
  else
    loglog(gun(:,1),abs(gun(:,2:ind)),option);
  end    
end

subplot(224);
axis(glob_scale(4,:));
ind = size(grob)*[0;1];
if glob_hz
  if option=='0'
    loglog(grob(:,1)/(2*pi),abs(grob(:,2:ind)));
  else
    loglog(grob(:,1)/(2*pi),abs(grob(:,2:ind)),option);
  end    
else
  if option=='0'
    loglog(grob(:,1),abs(grob(:,2:ind)));
  else
    loglog(grob(:,1),abs(grob(:,2:ind)),option);
  end    
end
axis;
