function omega_b = bwidth(fr)
% BWIDTH Computes bandwidth from a frequency response
%
%       OMEGA_B = BWIDTH(FR)
%
%       Given a frequency response FR, the frequency OMEGA_B at which
%       the amplitude has dropped 3dB compared to the stationary gain.
%       The stationary gain is taken as the amplitude at the first
%       frequency in FR.

% Mats Lilja
% LastEditDate : Thu May 30 09:04:22 1991
% Copyright (c) 1990 by Mats Lilja and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

omegas = levcross([fr(:,1) abs(fr(:,2)/fr(1,2))],1/sqrt(2));
if length(omegas) == 1,
  omega_b = omegas;
else,
  error('The bandwidth is not well-defined');
end;

