function ampl(fr1,fr2,fr3,fr4,scale)
% AMPL  Plot the amplitude of a frequency response.
%
%       ampl(fr1,fr2,fr3,fr4,scale)
%
%       An amplitude plot is done from the frequency responses in fr1 - fr4. 
%       The arguments fr2 - fr4 are optional. fr1 - fr4 is allowed to have
%       different number of data points and columns.
%
%	The optional argument scale is used to affect the scaling of the 
%       plot. It takes the form [wmin wmax amin amax]. All values are
%       given in 10-logarithm, i.e. amin = -1, amax = 2 corresponds to an 
%	amplitude scale from 0.1 to 100. scale can be used even if fr2 - 
%	fr4 are omitted.
%
%       The scale of the amplitude plot is stored in the variable glob_scale,
%       which must be declared as global. The scale is used to be able to 
%       draw (using AMSH) consecutive plots in the same diagram.
%
%       The frequency axis will be marked in Hz if the global variable
%	glob_hz has a value differing from 0.

% Kjell Gustafsson    
% LastEditDate : Wed Mar  7 14:45:22 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

%if frcheck, return, end
glob_hz=0;

if nargin~=5
  scale = eval(['fr' int2str(nargin)]);
end
scaleinfo = all(size(scale) == [1 4]);

ind = sprintf('(:,2:%g)',size(fr1)*[0;1]);
if glob_hz,
  plotamp = ['loglog(fr1(:,1)/(2*pi),abs(fr1' ind ')'];
else
  plotamp = ['loglog(fr1(:,1),abs(fr1' ind ')'];
end;

for k=2:nargin-scaleinfo,
  kstr = int2str(k);
  eval(['ind = sprintf(''(:,2:%g)'',size(fr' kstr ')*[0;1]);'])
  if glob_hz,
    plotamp = [plotamp ',fr' kstr '(:,1)/(2*pi),abs(fr' kstr ind ')'];
  else
    plotamp = [plotamp ',fr' kstr '(:,1),abs(fr' kstr ind ')'];
  end
end
plotamp = [plotamp ');'];

subplot(111)
if scaleinfo, axis(scale); end
eval(plotamp);
glob_scale = axis;
if ~scaleinfo, axis; end

ylabel('Magnitude');
if glob_hz,
  xlabel('Frequency [Hz]');
else
  xlabel('Frequency [rad/s]');
end

