-------------------------------------------------------------------------------
--                            GearScoreLite                                  --
--                             Version 3x06                                  --
--								Mirrikat45                                   --
-------------------------------------------------------------------------------

--GS_PlayerIsInCombat = false;

-- OnEvent handle gearscore, ilvl and dkp updates.
function GearScore_OnEvent(GS_Nil, GS_EventName, GS_Prefix, GS_AddonMessage, GS_Whisper, GS_Sender)
	if ( GS_EventName == "PLAYER_EQUIPMENT_CHANGED" ) then
	    local MyGearScore, MyItemLevel = GearScore_GetScore(UnitName("player"), "player");
		local Red, Blue, Green = GearScore_GetQuality(MyGearScore);
		
		if GS_Settings["DKP"] == 1 then
			GearScoreDKP_GetDKP();
		end
		
    	PersonalGearScore:SetText("GS: "..MyGearScore);
		PersonalGearScore:SetTextColor(Red, Green, Blue, 1);
		
		if (GS_Settings["iLevel"] == 1) then
			PersonalItemLevel:SetText("iLevel: "..MyItemLevel);
			PersonalItemLevel:SetTextColor(Red, Green, Blue, 1);
		end
  	end
	
	if ( GS_EventName == "ADDON_LOADED" ) then
		if ( GS_Prefix == "GearScoreLite" ) then
			if not ( GS_Guilds ) then GS_Guilds = {} end
			if not ( GS_Guids ) then GS_Guids = {} end
			if not ( GS_MyTip ) then GS_MyTip = GS_DefaultMyTip end
      		if not ( GS_Settings ) then	GS_Settings = GS_DefaultSettings end
			if not ( GS_Data ) then GS_Data = {}; end; if not ( GS_Data[GetRealmName()] ) then GS_Data[GetRealmName()] = { ["Players"] = {} }; end
  			for i, v in pairs(GS_DefaultSettings) do if not ( GS_Settings[i] ) then GS_Settings[i] = GS_DefaultSettings[i]; end; end
        end
	end
end
-------------------------- Get Mouseover Score -----------------------------------
function GearScore_GetScore(Name, Target)
	if ( UnitIsPlayer(Target) ) then
	    local PlayerClass, PlayerEnglishClass = UnitClass(Target);
		local GearScore = 0; local PVPScore = 0; local ItemCount = 0; local LevelTotal = 0; local TitanGrip = 1; local TempEquip = {}; local TempPVPScore = 0

		if ( GetInventoryItemLink(Target, 16) ) and ( GetInventoryItemLink(Target, 17) ) then
      		local ItemName, ItemLink, ItemRarity, ItemLevel, ItemMinLevel, ItemType, ItemSubType, ItemStackCount, ItemEquipLoc, ItemTexture = GetItemInfo(GetInventoryItemLink(Target, 16))
            if ( ItemEquipLoc == "INVTYPE_2HWEAPON" ) then TitanGrip = 0.5; end
		end

		if ( GetInventoryItemLink(Target, 17) ) then
			local ItemName, ItemLink, ItemRarity, ItemLevel, ItemMinLevel, ItemType, ItemSubType, ItemStackCount, ItemEquipLoc, ItemTexture = GetItemInfo(GetInventoryItemLink(Target, 17))
			if ( ItemEquipLoc == "INVTYPE_2HWEAPON" ) then TitanGrip = 0.5; end
			TempScore, ItemLevel = GearScore_GetItemScore(GetInventoryItemLink(Target, 17));
			if ( PlayerEnglishClass == "HUNTER" ) then TempScore = TempScore * 0.3164; end
			GearScore = GearScore + TempScore * TitanGrip;	ItemCount = ItemCount + 1; LevelTotal = LevelTotal + ItemLevel
		end
		
		for i = 1, 18 do
			if ( i ~= 4 ) and ( i ~= 17 ) then
        		ItemLink = GetInventoryItemLink(Target, i)
        		GS_ItemLinkTable = {}
				if ( ItemLink ) then
        			local ItemName, ItemLink, ItemRarity, ItemLevel, ItemMinLevel, ItemType, ItemSubType, ItemStackCount, ItemEquipLoc, ItemTexture = GetItemInfo(ItemLink)
        			if ( GS_Settings["Detail"] == 1 ) then GS_ItemLinkTable[i] = ItemLink; end
     				TempScore = GearScore_GetItemScore(ItemLink);
					if ( i == 16 ) and ( PlayerEnglishClass == "HUNTER" ) then TempScore = TempScore * 0.3164; end
					if ( i == 18 ) and ( PlayerEnglishClass == "HUNTER" ) then TempScore = TempScore * 5.3224; end
					if ( i == 16 ) then TempScore = TempScore * TitanGrip; end
					GearScore = GearScore + TempScore;	ItemCount = ItemCount + 1; LevelTotal = LevelTotal + ItemLevel
				end
			end;
		end
		if ( GearScore <= 0 ) and ( Name ~= UnitName("player") ) then
			GearScore = 0; return 0,0;
		elseif ( Name == UnitName("player") ) and ( GearScore <= 0 ) then
		    GearScore = 0; end
	if ( ItemCount == 0 ) then LevelTotal = 0; end
	return floor(GearScore), floor(LevelTotal/ItemCount)
	end
end

-------------------------------------------------------------------------------

function GearScore_GetEnchantInfo(ItemLink, ItemEquipLoc)
	local found, _, ItemSubString = string.find(ItemLink, "^|c%x+|H(.+)|h%[.*%]");
	local ItemSubStringTable = {}

	for v in string.gmatch(ItemSubString, "[^:]+") do tinsert(ItemSubStringTable, v); end
	ItemSubString = ItemSubStringTable[2]..":"..ItemSubStringTable[3], ItemSubStringTable[2]
	local StringStart, StringEnd = string.find(ItemSubString, ":") 
	ItemSubString = string.sub(ItemSubString, StringStart + 1)
	if ( ItemSubString == "0" ) and ( GS_ItemTypes[ItemEquipLoc]["Enchantable"] )then
		 --table.insert(MissingEnchantTable, ItemEquipLoc)
		 local percent = ( floor((-2 * ( GS_ItemTypes[ItemEquipLoc]["SlotMOD"] )) * 100) / 100 );
		 return(1 + (percent/100));
	else
	return 1;
	end
	
end						


------------------------------ Get Item Score ---------------------------------
function GearScore_GetItemScore(ItemLink)
	local QualityScale = 1; local PVPScale = 1; local PVPScore = 0; local GearScore = 0
	if not ( ItemLink ) then return 0, 0; end
	local ItemName, ItemLink, ItemRarity, ItemLevel, ItemMinLevel, ItemType, ItemSubType, ItemStackCount, ItemEquipLoc, ItemTexture = GetItemInfo(ItemLink); local Table = {}; local Scale = 1.8618
 	if ( ItemRarity == 5 ) then QualityScale = 1.3; ItemRarity = 4;
	elseif ( ItemRarity == 1 ) then QualityScale = 0.005;  ItemRarity = 2
	elseif ( ItemRarity == 0 ) then QualityScale = 0.005;  ItemRarity = 2 end
    if ( ItemRarity == 7 ) then ItemRarity = 3; ItemLevel = 187.05; end
    if ( GS_ItemTypes[ItemEquipLoc] ) then
        if ( ItemLevel > 120 ) then Table = GS_Formula["A"]; else Table = GS_Formula["B"]; end
		if ( ItemRarity >= 2 ) and ( ItemRarity <= 4 )then
            local Red, Green, Blue = GearScore_GetQuality((floor(((ItemLevel - Table[ItemRarity].A) / Table[ItemRarity].B) * 1 * Scale)) * 11.25 )
            GearScore = floor(((ItemLevel - Table[ItemRarity].A) / Table[ItemRarity].B) * GS_ItemTypes[ItemEquipLoc].SlotMOD * Scale * QualityScale)
			if ( ItemLevel == 187.05 ) then ItemLevel = 0; end
			if ( GearScore < 0 ) then GearScore = 0;   Red, Green, Blue = GearScore_GetQuality(1); end
			if ( PVPScale == 0.75 ) then PVPScore = 1; GearScore = GearScore * 1; 
			else PVPScore = GearScore * 0; end
			local percent = (GearScore_GetEnchantInfo(ItemLink, ItemEquipLoc) or 1)
			GearScore = floor(GearScore * percent )
			PVPScore = floor(PVPScore)
			return GearScore, ItemLevel, GS_ItemTypes[ItemEquipLoc].ItemSlot, Red, Green, Blue, PVPScore, ItemEquipLoc, percent ;
		end
  	end
  	return -1, ItemLevel, 50, 1, 1, 1, PVPScore, ItemEquipLoc, 1
end
-------------------------------------------------------------------------------

-------------------------------- Get Quality ----------------------------------

function GearScore_GetQuality(ItemScore)
	if ( ItemScore > 5999 ) then ItemScore = 5999; end
	local Red = 0.1; local Blue = 0.1; local Green = 0.1; local GS_QualityDescription = "Legendary"
   	if not ( ItemScore ) then return 0, 0, 0, "Trash"; end
	for i = 0,6 do
		if ( ItemScore > i * 1000 ) and ( ItemScore <= ( ( i + 1 ) * 1000 ) ) then
		    local Red = GS_Quality[( i + 1 ) * 1000].Red["A"] + (((ItemScore - GS_Quality[( i + 1 ) * 1000].Red["B"])*GS_Quality[( i + 1 ) * 1000].Red["C"])*GS_Quality[( i + 1 ) * 1000].Red["D"])
            local Blue = GS_Quality[( i + 1 ) * 1000].Green["A"] + (((ItemScore - GS_Quality[( i + 1 ) * 1000].Green["B"])*GS_Quality[( i + 1 ) * 1000].Green["C"])*GS_Quality[( i + 1 ) * 1000].Green["D"])
            local Green = GS_Quality[( i + 1 ) * 1000].Blue["A"] + (((ItemScore - GS_Quality[( i + 1 ) * 1000].Blue["B"])*GS_Quality[( i + 1 ) * 1000].Blue["C"])*GS_Quality[( i + 1 ) * 1000].Blue["D"])
			--if not ( Red ) or not ( Blue ) or not ( Green ) then return 0.1, 0.1, 0.1, nil; end
			return Red, Green, Blue, GS_Quality[( i + 1 ) * 1000].Description
		end
	end
return 0.1, 0.1, 0.1
end
-------------------------------------------------------------------------------

----------------------------- Hook Set Unit -----------------------------------
function GearScore_HookSetUnit(arg1, arg2)
	if ( GS_PlayerIsInCombat ) then return; end
	local Name = GameTooltip:GetUnit();local MouseOverGearScore, MouseOverAverage = 0,0
	if ( CanInspect("mouseover") ) and ( UnitName("mouseover") == Name ) and not ( GS_PlayerIsInCombat ) then 
		NotifyInspect("mouseover"); MouseOverGearScore, MouseOverAverage = GearScore_GetScore(Name, "mouseover"); 
	end
	
	-- Is the player friendly and not unknown? Build a tooltip if so.
	local guid = UnitGUID("mouseover");
	if guid ~= nil then
		local B = tonumber(guid:sub(5,5), 16);
		local maskedB = B % 8;
		local knownTypes = {[0] = "player",[3] = "NPC",[4] = "pet",[5] = "vehicle"};
		if (Name ~= "Unknown") and (knownTypes[maskedB] == "player") then
			
			if UnitIsFriend("player", "mouseover") ~= nil then
				if GearScoreToolTip_Exists(Name) then
					GameTooltip:AddLine(GS_ToolTips[Name].Tip, 1, 0, 0);
				else
					GearScoreToolTip_Request(Name);
				end
			end
			
		end
	end
	
 	if ( MouseOverGearScore ) and ( MouseOverGearScore > 0 ) then 
		local Red, Blue, Green = GearScore_GetQuality(MouseOverGearScore)
		if ( GS_Settings["iLvlMode"] == 1 ) then
			GameTooltip:AddLine("iLevel: "..MouseOverAverage, Red, Green, Blue)
		elseif ( GS_Settings["Player"] == 1 ) then
			if ( GS_Settings["Level"] == 1 ) then 
				GameTooltip:AddDoubleLine("GearScore: "..MouseOverGearScore, "(iLevel: "..MouseOverAverage..")", Red, Green, Blue, Red, Green, Blue)
			else
				GameTooltip:AddLine("GearScore: "..MouseOverGearScore, Red, Green, Blue)
			end
			if ( GS_Settings["Compare"] == 1 ) then
				local MyGearScore = GearScore_GetScore(UnitName("player"), "player");
				local TheirGearScore = MouseOverGearScore
				if ( MyGearScore  > TheirGearScore  ) then GameTooltip:AddDoubleLine("YourScore: "..MyGearScore  , "(+"..(MyGearScore - TheirGearScore  )..")", 0,1,0, 0,1,0); end
				if ( MyGearScore   < TheirGearScore   ) then GameTooltip:AddDoubleLine("YourScore: "..MyGearScore, "(-"..(TheirGearScore - MyGearScore  )..")", 1,0,0, 1,0,0); end	
				if ( MyGearScore   == TheirGearScore   ) then GameTooltip:AddDoubleLine("YourScore: "..MyGearScore  , "(+0)", 0,1,1,0,1,1); end	
			end
			
			if ( GS_Settings["Special"] == 1 ) and ( GS_Special[Name] ) then GameTooltip:AddLine(GS_Special[GS_Special[Name].Type], 1, 0, 0 ); end
		end
	end
end

function GearScore_SetDetails(tooltip, Name)
    if not ( UnitName("mouseover") ) or ( UnitName("mouseover") ~= Name )then return; end
  	for i = 1,18 do
  	    if not ( i == 4 ) then
    		local ItemName, ItemLink, ItemRarity, ItemLevel, ItemMinLevel, ItemType, ItemSubType, ItemStackCount, ItemEquipLoc, ItemTexture = GetItemInfo(GS_ItemLinkTable[i])
			if ( ItemLink ) then
				local GearScore, ItemLevel, ItemType, Red, Green, Blue = GearScore_GetItemScore(ItemLink)
				--local Red, Green, Blue = GearScore_GetQuality((floor(((ItemLevel - Table[ItemRarity].A) / Table[ItemRarity].B) * 1 * 1.8618)) * 11.25 )
				if ( GearScore ) and ( i ~= 4 ) then
    			   	local Add = ""
	        		if ( GS_Settings["Level"] == 1 ) then Add = " (iLevel "..tostring(ItemLevel)..")"; end
    	         	tooltip:AddDoubleLine("["..ItemName.."]", tostring(GearScore)..Add, GS_Rarity[ItemRarity].Red, GS_Rarity[ItemRarity].Green, GS_Rarity[ItemRarity].Blue, Red, Blue, Green)
        		end
			end
		end
	end
end
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
function GearScore_HookSetItem() ItemName, ItemLink = GameTooltip:GetItem(); GearScore_HookItem(ItemName, ItemLink, GameTooltip); end
function GearScore_HookRefItem() ItemName, ItemLink = ItemRefTooltip:GetItem(); GearScore_HookItem(ItemName, ItemLink, ItemRefTooltip); end
function GearScore_HookCompareItem() ItemName, ItemLink = ShoppingTooltip1:GetItem(); GearScore_HookItem(ItemName, ItemLink, ShoppingTooltip1); end
function GearScore_HookCompareItem2() ItemName, ItemLink = ShoppingTooltip2:GetItem(); GearScore_HookItem(ItemName, ItemLink, ShoppingTooltip2); end
function GearScore_HookItem(ItemName, ItemLink, Tooltip)
	if ( GS_PlayerIsInCombat ) then return; end
	local PlayerClass, PlayerEnglishClass = UnitClass("player");
	
	-- Display Item ID
	if GS_Settings["ItemID"] == 1 then
		local itemString = string.match(ItemLink, "item[%-?%d:]+");
		local _, ItemID, _ = strsplit(":", itemString)
		Tooltip:AddDoubleLine("ID: "..ItemID, "", Red, Blue, Green, Red, Blue, Green); 
	end
	
	if not ( IsEquippableItem(ItemLink) ) then return; end
	local ItemScore, ItemLevel, EquipLoc, Red, Green, Blue, PVPScore, ItemEquipLoc, enchantPercent = GearScore_GetItemScore(ItemLink);
	
 	if ( ItemScore >= 0 ) then
		if ( GS_Settings["Item"] == 1 ) then
  			if ( ItemLevel ) and ( GS_Settings["Level"] == 1 ) then
				
				-- Display GS with ilvl
				Tooltip:AddDoubleLine("GearScore: "..ItemScore, "(iLevel "..ItemLevel..")", Red, Blue, Green, Red, Blue, Green);
				
				if ( PlayerEnglishClass == "HUNTER" ) then
					if ( ItemEquipLoc == "INVTYPE_RANGEDRIGHT" ) or ( ItemEquipLoc == "INVTYPE_RANGED" ) then
						Tooltip:AddLine("HunterScore: "..floor(ItemScore * 5.3224), Red, Blue, Green)
					end
					if ( ItemEquipLoc == "INVTYPE_2HWEAPON" ) or ( ItemEquipLoc == "INVTYPE_WEAPONMAINHAND" ) or ( ItemEquipLoc == "INVTYPE_WEAPONOFFHAND" ) or ( ItemEquipLoc == "INVTYPE_WEAPON" ) or ( ItemEquipLoc == "INVTYPE_HOLDABLE" )  then
						Tooltip:AddLine("HunterScore: "..floor(ItemScore * 0.3164), Red, Blue, Green)
					end
				end
			else
				-- Display GS without ilvl
				Tooltip:AddDoubleLine("GearScore: "..ItemScore, "", Red, Blue, Green, Red, Blue, Green);
				if ( PlayerEnglishClass == "HUNTER" ) then
					if ( ItemEquipLoc == "INVTYPE_RANGEDRIGHT" ) or ( ItemEquipLoc == "INVTYPE_RANGED" ) then
						Tooltip:AddLine("HunterScore: "..floor(ItemScore * 5.3224), Red, Blue, Green)
					end
					if ( ItemEquipLoc == "INVTYPE_2HWEAPON" ) or ( ItemEquipLoc == "INVTYPE_WEAPONMAINHAND" ) or ( ItemEquipLoc == "INVTYPE_WEAPONOFFHAND" ) or ( ItemEquipLoc == "INVTYPE_WEAPON" ) or ( ItemEquipLoc == "INVTYPE_HOLDABLE" )  then
						Tooltip:AddLine("HunterScore: "..floor(ItemScore * 0.3164), Red, Blue, Green)
					end
				end
    		end
		end
	else
	    if ( GS_Settings["iLevel"] == 1 ) and ( ItemLevel ) then
	        Tooltip:AddLine("iLevel "..ItemLevel)
		end
    end
end
function GearScore_OnEnter(Name, ItemSlot, Argument)
	if ( UnitName("target") ) then NotifyInspect("target"); GS_LastNotified = UnitName("target"); end
	local OriginalOnEnter = GearScore_Original_SetInventoryItem(Name, ItemSlot, Argument); return OriginalOnEnter
end
function MyPaperDoll()
	if ( GS_PlayerIsInCombat ) then return; end
	local MyGearScore, MyItemLevel = GearScore_GetScore(UnitName("player"), "player");
	local Red, Blue, Green = GearScore_GetQuality(MyGearScore)
	
	if GS_Settings["DKP"] == 1 then
		GearScoreDKP_GetDKP();
	end
	
    PersonalGearScore:SetText("GS: "..MyGearScore);
	PersonalGearScore:SetTextColor(Red, Green, Blue, 1);
	
	if (GS_Settings["iLevel"] == 1) then
		PersonalItemLevel:SetText("iLevel: "..MyItemLevel);
		PersonalItemLevel:SetTextColor(Red, Green, Blue, 1);
	end
end
-------------------------------------------------------------------------------

-- Timer for update checker
local timerEnabled = false;
local total = 0;
local function onUpdate(self, elapsed)
	if not timerEnabled then
		return
	end
	total = total + elapsed;
	if total >= 5 then
		if GS_VerCheck then
			timerEnabled = false;
			total = 0;
			print("Your version of GSLite is up to date");
		end
	end
end

local timer = CreateFrame("frame");
timer:SetScript("OnUpdate", onUpdate);

----------------------------- Reports -----------------------------------------

---------------GS-SPAM Slash Command--------------------------------------
function GS_MANSET(Command)
	if (strlower(Command) == "dkp" ) then
		GS_Settings["DKP"] = GS_Settings["DKP"] * -1;
		
		if GS_Settings["DKP"] == 1 then
			GearScoreDKP_GetDKP();
			print("DKP: On");
		else
			PersonalDKP_Net:SetText("");
			PersonalDKP_Tot:SetText("");
			print("DKP: Off");
		end
		
		return
	end
	
	if (strlower(Command) == "ilvlmode") then
		GS_Settings["iLvlMode"] = GS_Settings["iLvlMode"] * -1;
		
		if GS_Settings["iLvlMode"] == 1 then
			GS_Settings["Player"] = -1;
			print("Only iLevel will be displayed on player tooltips.");
		else
			GS_Settings["Player"] = 1;
			print("GearScore is now displayed on player tooltips.");
		end
		
		return
	end
	
	if (strlower(Command) == "version") then
		print("GSLite Version: "..GS_Version);
		
		print("Requesting updates..");
		timerEnabled = true;
		GS_VerCheck = true;
		GSU_BroadCast("REQUEST", "RAID");
		GSU_BroadCast("REQUEST", "GUILD");
		
		return
	end
	
	if (strlower(string.sub(Command, 0, 3)) == "tip") then
		GS_MyTip[GearScoreTips_PlayerKey()] = string.sub(Command, 5, 44);
		GearScoreToolTip_Broadcast(GS_MyTip[GearScoreTips_PlayerKey()]);
		
		print("Your tooltip is now: "..GS_MyTip[GearScoreTips_PlayerKey()]);
		
		return
	end
	
	if (strlower(string.sub(Command, 0, 7)) == "set dkp") then
		local s,e,n = string.find(Command, "set dkp (%d+)");
		GearScoreDKP_SetCap(tonumber(n));
		print("DKP Max is now "..n);
		
		return
	end
	
	if (strlower(Command) == "ilevel" ) then
		GS_Settings["iLevel"] = GS_Settings["iLevel"] * -1;
		
		if (GS_Settings["iLevel"] == 1) then
			local MyGearScore, MyItemLevel = GearScore_GetScore(UnitName("player"), "player");
			local Red, Blue, Green = GearScore_GetQuality(MyGearScore);
			
			PersonalItemLevel:SetText("iLevel: "..MyItemLevel);
			PersonalItemLevel:SetTextColor(Red, Green, Blue, 1);
			
			PersonalGearScore:SetPoint("BOTTOMLEFT",PaperDollFrame,"TOPLEFT",72,-253)
			print("Item Levels: On");
		else
			PersonalGearScore:SetPoint("BOTTOMLEFT",PaperDollFrame,"TOPLEFT",72,-265)
			PersonalItemLevel:SetText("");
			print("Item Levels: Off");
		end
		
		return
	end
	
	if (strlower(Command) == "level") then
		GS_Settings["Level"] = GS_Settings["Level"] * -1;
		
		print("Level display toggled.");
		
		return
	end
	
	if (strlower(Command) == "") or (strlower(Command) == "options") or (strlower(Command) == "option") or (strlower(Command) == "help") then
		for i,v in ipairs(GS_CommandList)
			do print(v);
		end
		
		return
	end
	
	if (strlower(Command) == "player") then
		GS_Settings["Player"] = GS_ShowSwitch[GS_Settings["Player"]];
		
		if (GS_Settings["Player"] == 1) or (GS_Settings["Player"] == 2) then
			print("Player Scores: On");
			GS_Settings["iLvlMode"] = -1;
		else
			print("Player Scores: Off");
		end
		return
	end

	if (strlower(Command) == "item") then
		GS_Settings["Item"] = GS_ItemSwitch[GS_Settings["Item"]];
		
		if (GS_Settings["Item"] == 1) or (GS_Settings["Item"] == 3) then
			print("Item Scores: On");
		else
			print("Item Scores: Off");
		end
		return
	end

	if (strlower(Command) == "compare") then
		GS_Settings["Compare"] = GS_Settings["Compare"] * -1;
		
		if (GS_Settings["Compare"] == 1) then
			print("Comparisons: On");
		else
			print("Comparisons: Off");
		end
		return
	end
	
	print("GearScore: Unknown Command. Type '/gs' for a list of options")
end


------------------------ GUI PROGRAMS -------------------------------------------------------

local f = CreateFrame("Frame", "GearScore", UIParent);
f:SetScript("OnEvent", GearScore_OnEvent);
f:RegisterEvent("PLAYER_EQUIPMENT_CHANGED");
f:RegisterEvent("ADDON_LOADED");
--f:RegisterEvent("PLAYER_LEAVE_COMBAT")

GameTooltip:HookScript("OnTooltipSetUnit", GearScore_HookSetUnit)
GameTooltip:HookScript("OnTooltipSetItem", GearScore_HookSetItem)
ShoppingTooltip1:HookScript("OnTooltipSetItem", GearScore_HookCompareItem)
ShoppingTooltip2:HookScript("OnTooltipSetItem", GearScore_HookCompareItem2)
ItemRefTooltip:HookScript("OnTooltipSetItem", GearScore_HookRefItem)
PaperDollFrame:HookScript("OnShow", MyPaperDoll)

-- Create Frames
PaperDollFrame:CreateFontString("PersonalGearScore")
PaperDollFrame:CreateFontString("PersonalItemLevel")
PaperDollFrame:CreateFontString("PersonalDKP_Tot")
PaperDollFrame:CreateFontString("PersonalDKP_Net")

-- DKP Total
PersonalDKP_Tot:SetFont("Fonts\\FRIZQT__.TTF", 10)
PersonalDKP_Tot:SetText("")
PersonalDKP_Tot:SetPoint("BOTTOMLEFT",PaperDollFrame,"TOPLEFT",240,-265)
PersonalDKP_Tot:Show()

-- DKP Net
PersonalDKP_Net:SetFont("Fonts\\FRIZQT__.TTF", 10)
PersonalDKP_Net:SetText("")
PersonalDKP_Net:SetPoint("BOTTOMLEFT",PaperDollFrame,"TOPLEFT",240,-253)
PersonalDKP_Net:Show()

-- GS
PersonalGearScore:SetFont("Fonts\\FRIZQT__.TTF", 10)
PersonalGearScore:SetText("GS: 0")
PersonalGearScore:SetPoint("BOTTOMLEFT",PaperDollFrame,"TOPLEFT",72,-253)
PersonalGearScore:Show()

-- iLvl
PersonalItemLevel:SetFont("Fonts\\FRIZQT__.TTF", 10)
PersonalItemLevel:SetText("")
PersonalItemLevel:SetPoint("BOTTOMLEFT",PaperDollFrame,"TOPLEFT",72,-265)
PersonalItemLevel:Show()

--PaperDollFrame:CreateFontString("GearScore2")
--GearScore2:SetFont("Fonts\\FRIZQT__.TTF", 10)
--GearScore2:SetText("GearScore")
--GearScore2:SetPoint("BOTTOMLEFT",PaperDollFrame,"TOPLEFT",72,-265)
--GearScore2:Show()

GearScore_Original_SetInventoryItem = GameTooltip.SetInventoryItem
GameTooltip.SetInventoryItem = GearScore_OnEnter

SlashCmdList["MY2SCRIPT"] = GS_MANSET
SLASH_MY2SCRIPT1 = "/gs"
SLASH_MY2SCRIPT2 = "/gearscore"

